@echo off
rem ESET PROTECT
rem Copyright (c) 1992-2023 ESET, spol. s r.o. All Rights Reserved

call :install_agent
goto :eof

rem __Function install_agent___
:install_agent
setlocal EnableDelayedExpansion

set product_uuid=

set http_proxy_hostname=
set http_proxy_port=
set http_proxy_username=
set http_proxy_password=

set "scriptDirectory=%~dp0"

:uniqInstallDirectoryLoop
set "installDirectory=%temp%\.eset-%RANDOM%%RANDOM%%RANDOM%"
if exist "%installDirectory%" goto :uniqInstallDirectoryLoop
md "%installDirectory%" 2>NUL

if "%PROCESSOR_ARCHITECTURE%" == "x86" (
  if not defined PROCESSOR_ARCHITEW6432 (
    set IsArch_x86=true
  ) else (
    if "%PROCESSOR_ARCHITEW6432%" == "ARM64" (
      set IsArch_arm64=true
    )
  )
) else (
  if "%PROCESSOR_ARCHITECTURE%" == "ARM64" (
    set IsArch_arm64=true
  )
)

set url=http://repository.eset.com/v1/com/eset/apps/business/era/agent/v11/11.2.3029.0/agent_x64.msi
set checksum=b506a2faf01b75dd42a56dd46004a8c7f68a36c021e24bc64a614e3a1042ae77
if defined IsArch_x86 (
  set url=http://repository.eset.com/v1/com/eset/apps/business/era/agent/v11/11.2.3029.0/agent_x86.msi
  set checksum=9bddd45e2afc89c453c0eae126e3b4b5a464cb8d730690ce2cf38088e9e8bd71
)
if defined IsArch_arm64 (
  set url=http://repository.eset.com/v1/com/eset/apps/business/era/agent/v11/11.2.3029.0/agent_arm64.msi
  set checksum=e325008c279342915f865e396be6e388afcd5fae8a38c0b564d212d90d820a36
)

set "installConfigFile=%installDirectory%\install_config.ini"
echo.[ERA_AGENT_PROPERTIES] > "%installConfigFile%"
echo.P_INSTALL_MODE_EULA_ONLY=1 >> "%installConfigFile%"
echo.P_ENABLE_TELEMETRY=0 >> "%installConfigFile%"
echo.P_CONNECTION_CHOSEN=Host >> "%installConfigFile%"
echo.P_HOSTNAME=147.175.100.26 >> "%installConfigFile%"
echo.P_PORT=2222 >> "%installConfigFile%"
echo.P_INITIAL_STATIC_GROUP=MDAwMDAwMDAtMDAwMC0wMDAwLTcwMDEtMDAwMDAwMDAwMDAyN26kNsHqTeWqiQBpr4D+JFWnlHBAZkQJjoEFsL5xg6VUJIMdG3L7++C1GUvCWk38SX1XPw== >> "%installConfigFile%"
echo.P_USE_PROXY=0 >> "%installConfigFile%"
echo.P_PROXY_HTTP_HOSTNAME= >> "%installConfigFile%"
echo.P_PROXY_HTTP_PORT= >> "%installConfigFile%"
echo.P_PROXY_HTTP_USERNAME= >> "%installConfigFile%"
echo.P_PROXY_HTTP_PASSWORD= >> "%installConfigFile%"
echo|set /p="P_CERT_CONTENT=" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="OpvAryTBaVhb8UvErK50KNb2DC0SlJtifdSJx4UjfWrj+5b7cUeNHOoRt3J5IXdDxs+HYQ64jBA4nZiMV0bctylhCgIh2ihVom1yCqLmseNqm6dl0IwosZjB4r5KqMERC4XCK534ExZnqco9Unecyh4cu/P/bX2CSIq5hpry8fnZ1T3evHrfzpYkg0KyXB/oKhbuyzLrYTMaeXoTws3i3ZKh81l8xQIvRE0EdhsrfM1CL2sLvwC/YRW0naVjZtngvW2X8tZKKqMgw1jH41qMt5JEYLRYUU6j0v5GQWMClDJ3eE4XJAldXtlIW7+hKqok+CiQal0Ol6OX8c06CAb6JWmaN996V3hdyS5IZldLGLpxQzYkwQWFtLnzUdBs/COohZa0SD8rtD34OkSsC1+qlJbPqdsDNCBvExaWxZcO54ItevS75dP4RmriEVpuBrO7HEksD7Yy3HJk/zkiYgWmrneF/AedR24KLZrlTLC2YUHthw6ERB2h0sT+dvXXFY6vao/IefKdn4RLhQ7ahtynwxX4w/qzIfqChxIY/w2EZLUdr2Atf97ExUcoPbMzJUWlj3ZXSNTwS5xabc8SHcvN2X0rXGDN37DYfNdOipniZCXMMHEN4YHrD/hV1RchNsz3+EBQkpe3wIxzOqCCJXyg9qI6X9/3u6aIHlkJw8k1tGoUazQiM6TITfJyE8xrF3j1saHulXC+0Iw24dKM5FN++10VLu0N1S+fsq3VC1mOwdNwuPUFedWVMNfxe6z8jLu9OCrdtvS2DLwq74+cgpHoKpWEUV8FHeuk1DJPr7fATxn9NKd86OvzbPcasLUxz12AwHV/raAntuHnWOUdvSHfC4K2XsG7tVE+zW2RJx6swQqYgA0D87TzbGqBU+2N4pTM+TA7MB8wBwYFKw4DAhoEFOvRomRLFU21nCnyHRMlvg2mJzWmBBScbt3auN8UO9l91ZFEYUNktmJb3wICB9A=" >> "%installConfigFile%"
echo. >> "%installConfigFile%"

echo.P_CERT_PASSWORD_IS_BASE64=yes >> "%installConfigFile%"
echo.P_CERT_PASSWORD=Tk5FcmEyMDE1LkNvbnMy >> "%installConfigFile%"
echo.P_CERT_AUTH_CONTENT=MIIEuzCCAyOgAwIBAgIQc/AtfhXjdadL7Lczyt2N8DANBgkqhkiG9w0BAQUFADB2MScwJQYDVQQDEx5TZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDDAKBgNVBAsTA0ZFSTEQMA4GA1UEChMHRkVJIFNUVTELMAkGA1UEBxMCQkExETAPBgNVBAgTCFNsb3Zha2lhMQswCQYDVQQGEwJTSzAeFw0yNTA4MTkyMjAwMDBaFw0zNTA4MjAyMTU5NTlaMHYxJzAlBgNVBAMTHlNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEMMAoGA1UECxMDRkVJMRAwDgYDVQQKEwdGRUkgU1RVMQswCQYDVQQHEwJCQTERMA8GA1UECBMIU2xvdmFraWExCzAJBgNVBAYTAlNLMIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAxCSlJ5oNDJikQn4l7hXpv/XnCjLqlOpoMu4/7CUXAUmlBHrSAfbdBiDPlgz9DYhZ34IX0BkRw4r+rKEwi7lchmFZU9Fp8lrdsY1/wOBv5rH/gnhF4pYxMeDnJ20U9fhS64Lh1uxLcrK3nMcK/AvY71s6JG6mU8OD1dOgFpCd1ZNmd7XmOS3xZx/AoU7tioClVXEqGQLBMMaDVKc7rceIq8oqf8q1domRsPngl2DLeU3sF7Jv/NMfchD8/wKhvI0M8ki43KmK8KTLnyuO6DCBRtsUftpP97V0W3cqex8KMxv5733DN+O0StspVq1oTrs3s/zug4FcUUYUbD1z/UeUqAdSpI+nGh+Z7QTWqlQY9IbRHsr7qRJ2lNCJzXyodho6D9H5QZhQ/3kNfbIwfbbG8StJpPJPc+7bsq1YZY44m6RrSANSHxSJkwnP8jADroXy3hm4YeHteH2ym019FSuXftwRt00w9tsGquTYVvrdjjaoZgefvpBdIXE4f+LGTLqFAgMBAAGjRTBDMA4GA1UdDwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBRnXl5mFF91PjYndwVOxv8rVkTowjANBgkqhkiG9w0BAQUFAAOCAYEAO4BpNtnPa38d7pH40RQZ1unRk4wvn5jbjqciMfcQvUqORYQh6bn0Tfw10+BZ/GtMNIv1NQ9UpcEC5taPhHI4NuausO7NjRWtVkBfVxL5vIIylJldYq0ggTUZXFW2EQ37w/KwXh7btP+8hh5CpyxTVYkbf4bDV3NCyp1cX3krjScxycEVdZVC1yF7FF3PPegWnfKzpwqmySgJZkFe3Kgx73vp557JNXi+yWAKDWCTr3HCWCoSDV2Xof4lh6dGyv6P1D4didKPVHJzLmNnQ4xR0NoIYNO+kL6xnTq/BRzgAUVBx0wMUnS7YRLuPWhwFs8EBFgD/2qmTygHlLK1JBtaoXAoXgBj1t8InDhAxQfKr/f44pMxVlGs4yYPrr9HO4oJQmTpPWHu8eOCZ7P9pPGW84nMltTXXWdflYGPVnUgqSEAkj2kvtiMpZrWkvADFTR5LVclmTK2nIQuyi5eS7Flhse9xXSMsWclJRNxOsjjegiNsWXz0KGcyvHPy5RA/BOz >> "%installConfigFile%"
echo|set /p="P_CUSTOM_POLICY=" >> "%installConfigFile%"
echo|set /p="eyJwb2xpY3kiOnsiZm9ybWF0IjoxfX0KITxhcmNoPgovLyAgICAgICAgICAgICAgMTc2Mjc5MTY4MyAgMCAgICAgMCAgICAgNjQ0ICAgICAxOCAgICAgICAgYApvcmlnaW5hbFBvbGljaWVzLwovMCAgICAgICAgICAgICAgMTc2Mjc5MTY4MyAgMCAgICAgMCAgICAgNjQ0ICAgICAxMDY3MSAgICAgYApleUp3YjJ4cFkza2lPbnNpWm05eWJXRjBJam95TENKMlpYSnphVzl1WDIxaGFtOXlJam8wTWprME9UWTNNamsxTENKMlpYSnphVzl1WDIxcGJtOXlJam8wTWprME9UWTNNamsxTENKMlpYSnphVzl1WDJKMWFXeGtJam93TENKa1lYUmhJanA3SW5OMFlXNWtZV3h2Ym1VaU9uc2lVMlYwZEdsdVozTWlPbnNpVlhCa1lYUmxjaUk2ZXlKalpWOW1iR0ZuY3lJNk1Dd2lRWFYwYjFWd1pHRjBaWE1pT25zaVkyVmZabXhoWjNNaU9qQXNJa1Z1WVdKc1pXUWlPbnNpWTJWZlpteGhaM01pT2pRc0ltTmxYM1I1Y0dVaU9qWXNJbU5sWDNaaGJIVmxJam94Zlgwc0ltTmxYM1psY25OcGIyNGlPaUl6TGpBaWZYMTlmWDE5CmV5SndiMnhwWTNraU9uc2labTl5YldGMElqb3hMQ0ozY21sMGRHVnVYMko1WDJObElqb2lNakV3T1NBb01qQXlOREF4TVRrcE95QXlNVEl4SWl3aVpHRjBZU0k2ZXlKbFpXRmZkVzVwZUNJNmV5SmpaVjkyWlhKemFXOXVYMjFoYW05eUlqb3hNQ3dpWTJWZmRtVnljMmx2Ymw5dGFXNXZjaUk2TWl3aVkyVmZkbVZ5YzJsdmJsOWlkV2xzWkNJNk1Dd2lVMlYwZEdsdVozTWlPbnNpVEdsMlpVZHlhV1FpT25zaVRHbDJaVWR5YVdSRmJtRmliR1ZrSWpwN0ltTmxYM1I1Y0dVaU9qWXNJbU5sWDNaaGJIVmxJam94TENKalpWOW1iR0ZuY3lJNk5IMHNJbE4xWW0xcGRFbHVabVZqZEdWa1JtbHNaWE1pT25zaVkyVmZkSGx3WlNJNk5pd2lZMlZmZG1Gc2RXVWlPakVzSW1ObFgyWnNZV2R6SWpvMGZTd2lUR2wyWlVkeWFXUkdaV1ZrWW1GamEwVnVZV0pzWldRaU9uc2lZMlZmZEhsd1pTSTZOaXdpWTJWZmRtRnNkV1VpT2pFc0ltTmxYMlpzWVdkeklqbzBmWDE5ZlgxOWZRb2hQR0Z5WTJnK0NpOHZJQ0FnSUNBZ0lDQWdJQ0FnSUNBd0lDQWdJQ0FnSUNBZ0lDQXdJQ0FnSUNBd0lDQWdJQ0EyTkRRZ0lDQWdJREUxSUNBZ0lDQWdJQ0JnQ21WbFlWOTFibWw0TG14NmJXRXZDZ3BwYm1adkxtcHpiMjR2SUNBZ0lDQWdNQ0FnSUNBZ0lDQWdJQ0FnTUNBZ0lDQWdNQ0FnSUNBZ05qUTBJQ0FnSUNBMk55QWdJQ0FnSUNBZ1lBcDdDaUFpZDNKcGRIUmxibDlpZVY5alpTSTZJakl4TURrZ0tESXdNalF3TVRFNUtUc2dNakV5TVNJc0NpQWlZMjl0Y0dGMGFXSnBiR2wwZVNJNmV3b2dmUXA5Q2c9PQpleUp3YjJ4cFkza2lPbnNpWm05eWJXRjBJam94TENKM2NtbDBkR1Z1WDJKNVgyTmxJam9pTWpFd09TQW9NakF5TkRBeE1Ua3BPeUF5TVRJeElpd2laR0YwWVNJNmV5SmxibVJ3YjJsdWRGOXRZV01pT25zaVkyVmZkbVZ5YzJsdmJsOXRZV3B2Y2lJNk5pd2lZMlZmZG1WeWMybHZibDl0YVc1dmNpSTZNVEF3TENKalpWOTJaWEp6YVc5dVgySjFhV3hrSWpvd0xDSmtZV1Z0YjI0aU9uc2ljMlYwZEdsdVozTWlPbnNpWkdWc2FYWmxjbmxmYldGdVlXZGxjaUk2ZXlKbGJtRmliR1ZrSWpwN0ltTmxYM1I1Y0dVaU9qWXNJbU5sWDNaaGJIVmxJam94TENKalpWOW1iR0ZuY3lJNk5IMHNJbk5oYlhCc1pYTmZjMlZ1WkY5bWFXeGxjeUk2ZXlKalpWOTBlWEJsSWpvMkxDSmpaVjkyWVd4MVpTSTZNU3dpWTJWZlpteGhaM01pT2pSOWZYMTlmWDE5ZlFvaFBHRnlZMmcrQ2k4dklDQWdJQ0FnSUNBZ0lDQWdJQ0F3SUNBZ0lDQWdJQ0FnSUNBd0lDQWdJQ0F3SUNBZ0lDQTJORFFnSUNBZ0lERTVJQ0FnSUNBZ0lDQmdDbVZ1WkhCdmFXNTBYMjFoWXk1c2VtMWhMd29LYVc1bWJ5NXFjMjl1THlBZ0lDQWdJREFnSUNBZ0lDQWdJQ0FnSURBZ0lDQWdJREFnSUNBZ0lEWTBOQ0FnSUNBZ05qY2dJQ0FnSUNBZ0lHQUtld29nSW5keWFYUjBaVzVmWW5sZlkyVWlPaUl5TVRBNUlDZ3lNREkwTURFeE9TazdJREl4TWpFaUxBb2dJbU52YlhCaGRHbGlhV3hwZEhraU9uc0tJSDBLZlFvPQpleUp3YjJ4cFkza2lPbnNpWm05eWJXRjBJam94TENKM2NtbDBkR1Z1WDJKNVgyTmxJam9pTWpFd09TQW9NakF5TkRBeE1Ua3BPeUF5TVRJeElpd2laR0YwWVNJNmV5SmtaWE5yZEc5d1gyMWhZeUk2ZXlKalpWOTJaWEp6YVc5dVgyMWhhbTl5SWpvM0xDSmpaVjkyWlhKemFXOXVYMjFwYm05eUlqbzBMQ0pqWlY5MlpYSnphVzl1WDJKMWFXeGtJam93TENKVFpYUjBhVzVuY3lJNmV5Sk1hWFpsUjNKcFpDSTZleUpNYVhabFIzSnBaRVZ1WVdKc1pXUWlPbnNpWTJWZmRIbHdaU0k2Tml3aVkyVmZkbUZzZFdVaU9qRXNJbU5sWDJac1lXZHpJam8wZlN3aVUzVmliV2wwU1c1bVpXTjBaV1JHYVd4bGN5STZleUpqWlY5MGVYQmxJam8yTENKalpWOTJZV3gxWlNJNk1Td2lZMlZmWm14aFozTWlPalI5TENKTWFYWmxSM0pwWkVabFpXUmlZV05yUlc1aFlteGxaQ0k2ZXlKalpWOTBlWEJsSWpvMkxDSmpaVjkyWVd4MVpTSTZNU3dpWTJWZlpteGhaM01pT2pSOWZYMTlmWDE5Q2lFOFlYSmphRDRLTHk4Z0lDQWdJQ0FnSUNBZ0lDQWdJREFnSUNBZ0lDQWdJQ0FnSURBZ0lDQWdJREFnSUNBZ0lEWTBOQ0FnSUNBZ01UZ2dJQ0FnSUNBZ0lHQUtaR1Z6YTNSdmNGOXRZV011YkhwdFlTOEthVzVtYnk1cWMyOXVMeUFnSUNBZ0lEQWdJQ0FnSUNBZ0lDQWdJREFnSUNBZ0lEQWdJQ0FnSURZME5DQWdJQ0FnTmpjZ0lDQWdJQ0FnSUdBS2V3b2dJbmR5YVhSMFpXNWZZbmxmWTJVaU9pSXlNVEE1SUNneU1ESTBNREV4T1NrN0lESXhNakVpTEFvZ0ltTnZiWEJoZEdsaWFXeHBkSGtpT25zS0lIMEtmUW89CmV5SndiMnhwWTNraU9uc2labTl5YldGMElqb3hMQ0ozY21sMGRHVnVYMko1WDJObElqb2lNakV3T1NBb01qQXlOREF4TVRrcE95QXlNVEl4SWl3aVpHRjBZU0k2ZXlKbGRuTmZjMlZ5ZG1WeUlqcDdJbU5sWDNabGNuTnBiMjVmYldGcWIzSWlPakFzSW1ObFgzWmxjbk5wYjI1ZmJXbHViM0lpT2pBc0ltTmxYM1psY25OcGIyNWZZblZwYkdRaU9qQXNJbVJoWlcxdmJpSTZleUp6WlhSMGFXNW5jeUk2ZXlKa1pXeHBkbVZ5ZVY5dFlXNWhaMlZ5SWpwN0ltVnVZV0pzWldRaU9uc2lZMlZmZEhsd1pTSTZOaXdpWTJWZmRtRnNkV1VpT2pFc0ltTmxYMlpzWVdkeklq" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo. >> "%installConfigFile%"

for /f "tokens=2 delims=[]" %%G in ('ver') Do (set os_version=%%G)

for /f "tokens=2,3,4 delims=. " %%G in ('echo %os_version%') Do (set os_version_major=%%G& set os_version_minor=%%H& set os_version_build=%%I)

echo Installing ESET Management Agent...

> "%installDirectory%\uacinstall.vbs" (
echo.' ESET PROTECT
echo.' Copyright ^(c^) 1992-2023 ESET, spol. s r.o. All Rights Reserved
echo.
echo.Class CComputer
echo.    Private m_MACAddress
echo.    Private m_Parameters
echo.    Public Function Init^(MACAddress, Parameters^)
echo.        m_MACAddress = MACAddress
echo.        m_Parameters = Parameters
echo.        Set Init = Me
echo.    End Function
echo.    Public Property Get MACAddress
echo.        MACAddress = m_MACAddress
echo.    End Property
echo.    Public Property Get Parameters
echo.        Parameters = m_Parameters
echo.    End Property
echo.End Class
echo.
echo.Function GetCollectionCount^(collection^)
echo.    GetCollectionCount = 0
echo.    On Error Resume Next
echo.    GetCollectionCount = collection.Count
echo.End Function
echo.
echo.Function GetPackageName^(strLink^)
echo.    GetPackageName = Mid^(strLink, InStrRev^(strLink,"/"^) + 1, Len^(strLink^)^)
echo.End Function
echo.
echo.Function DownloadUsingHTTPProxy^(strLink, strProxyHostname, strProxyPort, strProxyUser, strProxyPassword^)
echo.    Set objFSO = CreateObject^("Scripting.FileSystemObject"^)
echo.    strSaveName = GetPackageName^(strLink^)
echo.    strSaveTo = "!installDirectory!" ^& "\" ^& strSaveName
echo.
echo.    Set objHTTP = CreateObject^("WinHttp.WinHttpRequest.5.1"^)
echo.    objHTTP.Open "GET", strLink, False
echo.    If Len^(strProxyHostname^) ^> 0 Then
echo.        objHttp.SetProxy 2, strProxyHostname ^& ":" ^& strProxyPort
echo.        If Len^(strProxyUser^) ^> 0 Then
echo.            const HTTPREQUEST_SETCREDENTIALS_FOR_PROXY = 1
echo.            objHTTP.SetCredentials strProxyUser, strProxyPassword, HTTPREQUEST_SETCREDENTIALS_FOR_PROXY
echo.        End If
echo.    End If
echo.    objHTTP.Send
echo.
echo.    If objFSO.FileExists^(strSaveTo^) Then
echo.        objFSO.DeleteFile^(strSaveTo^)
echo.    End If
echo.
echo.    If objHTTP.Status = 200 Then
echo.        Dim objStream
echo.        Set objStream = CreateObject^("ADODB.Stream"^)
echo.        With objStream
echo.            .Type = 1 'adTypeBinary
echo.            .Open
echo.            .Write objHTTP.ResponseBody
echo.            .SaveToFile strSaveTo
echo.            .Close
echo.        End With
echo.        Set objStream = Nothing
echo.    End If
echo.
echo.    If objFSO.FileExists^(strSaveTo^) Then
echo.        DownloadUsingHTTPProxy = strSaveTo
echo.    End If
echo.End Function
echo.
echo.Function DropSHA256Tool^(^)
echo.    Set objFSO = CreateObject^("Scripting.FileSystemObject"^)
echo.    strSaveName = "sha256sum.exe"
echo.    strSaveTo = "!installDirectory!" ^& "\" ^& strSaveName
echo.
echo.    If objFSO.FileExists^(strSaveTo^) Then
echo.        objFSO.DeleteFile^(strSaveTo^)
echo.    End If
echo.
echo.    Set oXML = CreateObject^("Msxml2.DOMDocument.3.0"^)
echo.    Set oNode = oXML.CreateElement^("base64"^)
echo.    oNode.dataType = "bin.base64"
echo.    oNode.text =               "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"
echo.    oNode.text = oNode.text ^& "////wegKM9DBzxaLRZiLyANVsMHJEsHIBzPIi0WYwegDM8iLRfQD0cHIGYtN3MHJCzPBA1WUi41E////wckGM8GJVZSLTfAzTfgjTYwzTYgDwYtN4ANB/ItNhANFyMHJDQPCM/kD8ItNgMHJAjP5iXXwi414////A/gjjXT///8L2YtN6IvRi8HByBED38HKEzPQiV3ci128i8HB6AqLyzPQwckSA1Woi8PByAczyIvDwegDM8iLxgPRi84DVZjByRmJVZjByAszyIudcP///zNd+IvGwcgGI94zyDNd+AONbP///4tF4APZi33ci8/ByRYDGIvHwcgNA9MzyIudaP///4vHA9rByAIzyItFzAuFZP///wPKI8eLvVz///8jvWD///8Lx4t9lAPBi024iUXMi9GLwcHKEsHIBzPQi8HB6AOLzzPQwckTA1XEi8fByBEzyIvHwegKM8iLvVD///8D0YvDA1W8i8vByAvByRkzyIlVvIvDwcgGM8iLxjOFWP///yPDM4VU////A8iLReADSAQDTfiLRcwD0YvIA/rByA3ByRYzyIl9/ItFzMHIAjPIi3XYi0XcA8oL8COFTP///yN1zAvwiXXYAU3Yi02Yi9GLwcHKE8HIETPQi3XYi8HB6Aoz0ItFrANVnIvIwcgHwckSM8iLRazB6AMzyIvHA8rByAuLVbgD0YvPwckZM8iJVbiLx8HIBjPIi0XwM8MjxzNF8APIi0XgA0gIA41I////i0WQA9EDwovOiUX0i8bByA3ByRYzyIvGwcgCM8iLRdyL8APKI0XMC3XMI3XYC/AD8YtNvIvRi8HByBHByhMz0IvBwegKM9CLRaSLyANV7MHIB8HJEjPIi0WkwegDM8gDyotV9AFNrIvCwcgLi8rByRkzyIvCwcgGM8iLwzPHI9CLReAz0wPRi87ByRYDUAwDVfADVayLRdwDwolF+IvGwcgNM8iLxsHIAjPIi0XMi/gDyiNF2At92CP+C/gD+YtNuIvRi8HByBHByhMz0IvBwegKM9CLRaADVeSLyMHIB8HJEjPIi0WgwegDM8gDyotV+AFNpIvCwcgLi8rByRkzyIvCi1X8wcgGM8iLwjNF9CNF+DPQA9GLReCLz8HJFgNQEItFzAPTA1Wki94Dwgtd2IlF8CPfi8fByA0zyIvHwcgCM8iLxiNF2APKC9gD2YtNrIvRi8HByBHByhMz0IvBwegKM9CLRdQDVeiLyMHIB8HJEjPIi0XUwegDM8gDyotV8AFNoIvCwcgLi8rByRkzyIvCi1X0wcgGM8iLwjNF+CNF8DPQi0XgA9GLy8HJFgNQFANV/ANVoItF2APCiUXIi8PByA0zyIvDwcgCM8iLxgvHI8OJRfyLxiPHCUX8A8oBTfyLTaSL0YvBwcoTwcgRM9CLwcHoCjPQi0W0A1WUi8jByAfByRIzyItFtMHoAzPIA8qLVcgBTdSLwsHIC4vKwckZM8iLwotV+MHIBjPIi8IzRfAjRcgz0ItF4APRA1AYA1X0A1XUjQQWi3X8iUXMi87ByRaLxsHIDTPIi8bByAIzyIvHC8MDyiPGiUX8i8cjwwlF/AFN/ItNoIvRi8HByhPByBEz0IvBwegKM9CLRbADVZiLyMHJEsHIBzPIi0WwwegDM8gDyotVzAFNtIvKi8LByAvByRkzyIvCwcgGM8iLVfCLwjNFyCNFzDPQi0XgA9EDUBwDVfgDVbSNBBeLffyJRdyLz8HJFovHwcgNM8iLx8HIAjPIi8MLxgPKI8eJRfyLwyPGCUX8AU38i03Ui9GLwcHKE8HIETPQi8HB6Aoz0ItFqANVvIvIwcgHwckSM8iLRajB6AMzyAPKi1XcAU2wi8KLysHIC8HJGTPIi8KLVcjByAYzyItFzDPCI0XcM9CLReAD0QNQIANV8ANVsI0EE4td/IlF8IvLwckWi8PByA0zyIvDwcgCM8iLxgvHA8ojw4lF+IvGI8cJRfgBTfiLTcSL0YvBwcoSwcgHM9CLwcHoAzPQi0W0A1Woi8jByBHByRMzyItFtMHoCjPIA8qLVfADTbiLwsHIC4lNqIvKwckZM8iLwotVzMHIBjPIi8IzRdwjRfAz0ItF4APRA1AkA1XIA1WojQQyi3X4iUXYi87ByRaLxsHIDTPIi8bByAIzyIvHC8MDyiPGiUX8i8cjwwlF/AFN/ItNsIvRi8HByhPByBEz0IvBwegKM9CLRZwDVayLyMHIB8HJEjPIi0WcwegDM8gDyotV2AFNxIvCwcgLi8rByRkzyIvCi1XcwcgGM8iLRfAzwiNF2DPQi0XgA9EDUCgDVcwDVcSNBDqLffyJRfSLz8HJFovHwcgNM8iLx8HIAjPIi8MLxgPKI8eJRfyLwyPGi3X8C/AD8YtN7IvRiXX8i3Woi8HByAfByhIz0IvBwegDi84z0MHJEwNVpIvGwcgRM8iLxot19MHoCjPIi8YDygFNnIvOwckZwcgLM8iLxsHIBjPIi0XYM0XwI/CLReAzdfAD8YtN/IvRA3AsA3XcA3WcwcoWjQQei134iUXIi8HByA0z0IvBwcgCi8sz0AvPI038A9aLdeSLwyPHC8GLTcQDwovRiUXAi8HByBHByhMz0IvBwegKi84z0MHJEgNVoIvGwcgHM8iLxot1yMHoAzPIi8YDysHICwFN7IvOwckZM8iLxsHIBjPIi0XYM0X0I/CLReAzddgD8YtNwIvRA3AwA3XwA3XswcoWjQQeiUXwi8HByA0z0Itd/IvBi8/ByAILyyNNwDPQA9aLxyPDi3XoC8GLTZwDwovRiUXci8HByBHByhMz0IvBwegKi84z0MHJEgNV1IvGwcgHM8iLxot18MHoAzPIi8YDysHICwFN5IvOwckZM8iLxsHIBjPIi0XIM0X0I/CLReAzdfQD8QNwNAN12AN15I0EPot93IlF+IvXwcoWi8fByA0z0IvHwcgCM9CLRcCLyAPyC8sjwyPPC8gD8YtN7IvRiXX8i8HByhPByBEz0IvBwegKi32UM9ADVeiLz8HJEovHwcgHM8iLx8HoAzPIi33AA8qLVfgDTbSLwolN6IvKwcgLwckZM8iLwsHIBjPIi0XIM0XwI9CLReAzVciDReBAA9GLzgNQOIvGA1X0A1XowcgNA9rByRYzyIld9Itd3IvGwcgCC/szyImdeP///4tFwCP+I8OJnWj///8Dygv4i0X0A/mBfeBkvkEAi9aLTfCLdcCJRdyJhUT///+JRYyJTYiJfYSJfYCJvXz///+JlXT///+JhXD///+JjWz///+JVcyJvWT///+JlWD///+JvVz///+JhVj///+JhVT///+JlVD///+JfdiJvUz///+JhUj///+JfZAPjAP2//+LRQiLtUD///8D94t90IvOiXXUiYiMAAAAg8dAiY1A////i408////A8qJfdCLVfQDlTD///+JiJAAAACJTfyJjTz///+LjTj///8Dy4lV7Itd+AOdLP///4mIlAAAAIlNuImNOP///4uNNP///wNNwImImAAAAIlNvImNNP///4vKiYicAAAAiY0w////i8uJiKAAAACJjSz///+LjSj///8DTfCJiKQAAACJTfSJjSj///+LjST///8DTciJiKgAAACLRRCJXeiJTZCJjST///+FwA+F5u3//19eW8nDVYvsU1aLdQhXhfYPhJUAAACLVQyF0g+EigAAAItGCGpAW4v7K/g5fRAPQn0Qg8AMV1IDxlDoYRgAAItGCIPEDItNEAPBO8NzB4lGCDPA61krz4PGDAN9DIvZagFW/3UIg+E/wesGiU0Q/xXE8kEAU1f/dQj/FcTyQQD/dRCLw8HgBgPHUFboEBgAAItNCIPEJItFEIlBCI1DAWpAWvfiAQERUQTrpjPAQF9eW13Dhcl1BDPAQMNWuqC+QQCNsYwAAACLAoPCBIkGjXYEgfrAvkEAfO4zwIlBCIkBiUEEuQAQQAChxPJBAIXAXg9EwaPE8kEAM8DDVYvsUVeL+YvCiUX8hf8PhKIAAACFwA+EmgAAAItFCIPg/IP4IHMIagJY6YoAAACLVwiLwoPgP1Mz2zw3i8IPl8MzyUMD"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "fZyNRfSLddSNjXz///+JRYwzwIN9zARRD5TAiZ18////QIldgFCJRdyNRYxQjUW4UOh5CQAAg8QQg/j/D4QDAgAA61UPtgcPvogA4kEAQYlN1DvKD4+eAQAAM8CJnXT///+D+QSJnXj///+NjXT///+JfcwPlMBAUVCJRdyNRcxQjUW4UOglCQAAg8QQg/j/D4SvAQAAi3XUTwP+63+KVAEt9sIEdB6KRAEugOL7iEXsigeIRe2LRdRqAohUAS2NRexQ60OKB4hF4+i/4f//D7ZN42Y5HEh9LI1HAYlFzDtFpA+DMQEAAGoCjUW4V1DoL6H//4PEDIP4/w+ERQEAAIt9zOsYagFXjUW4UOgSof//g8QMg/j/D4QoAQAAU1NqBY1F5EdQ/3XcjUW4iX2cUFP/dYjo3dT//4PEIIlFzIXAD4T+AAAAU41NoFFQjUXkUP91lP8VdGBBAIXAD4TaAAAAi3WwK3WYi0XMA/eJdaw5RaAPgswAAACAfdEKdTRqDVhTZolF0I1FoFBqAY1F0FD/dZT/FXRgQQCFwA+EmgAAAIN9oAEPgpkAAAD/RbBGiXWsO32kD4OJAAAAi02E6Xz9//+F0n4li/GLRbSLDIUI70EAigQ7A86LddwDy0OIRDEui3XYO9p84It1rAPygH3IAIl1rOtQhdJ+8Yt12ItFtIsMhQjvQQCKBDsDzohEGS5DO9p86OvRi1W0i03Yil3jiwSVCO9BAIhcAS6LBJUI70EAgEwBLQRG67P/FThgQQCJRag4Xch0CotFvIOgUAMAAP2LRQiNdaiLTfyL+DPNpaWlX15b6AM0///Jw4v/VYvsUVNWi3UIM8BXi/6rq6uLfQyLRRADx4lF/Dv4cz8Ptx9T6OU2AABZZjvDdSiDRgQCg/sKdRVqDVtT6M02AABZZjvDdRD/RgT/RgiDxwI7ffxyy+sI/xU4YEEAiQZfi8ZeW8nDi/9Vi+xRVot1CFdW6OElAABZhcB0VYv+g+Y/wf8Ga/Y4iwS9CO9BAIB8MCgAfTzonqb//4tATIO4qAAAAAB1DosEvQjvQQCAfDApAHQdjUX8UIsEvQjvQQD/dDAY/xWoYEEAhcB0BLAB6wIywF9eycOL/1WL7LgMFAAA6ApfAAChAOBBADPFiUX8i00Mi8GLVRSD4T/B+AZryThTi10IiwSFCO9BAFZXi/uLRAgYi00QA9GJhfjr//8zwKuJlfTr//+rqzvKc3OLvfjr//+Ntfzr//87ynMYigFBPAp1B/9DCMYGDUaIBkaNRfs78HLkjYX86///iU0QK/CNhfjr//9qAFBWjYX86///UFf/FXRgQQCFwHQci4X46///AUMEO8ZyF4tNEIuV9Ov//zvKcp3rCP8VOGBBAIkDi038i8NfXjPNW+hPMv//ycOL/1WL7LgQFAAA6C9eAAChAOBBADPFiUX8i00Mi8GLVRSD4T/B+AZryThTi10IiwSFCO9BAFZXi/uLRAgYi00QA9GJhfjr//8zwKuJlfDr//+rq+t1jbX86///O8pzJQ+3AYPBAoP4CnUNg0MIAmoNX2aJPoPGAmaJBoPGAo1F+jvwcteLvfjr//+Nhfzr//8r8IlNEGoAjYX06///g+b+UFaNhfzr//9QV/8VdGBBAIXAdByLhfTr//8BQwQ7xnIXi00Qi5Xw6///O8pyh+sI/xU4YEEAiQOLTfyLw19eM81b6GYx///Jw4v/VYvsuBgUAADoRl0AAKEA4EEAM8WJRfyLTQyLwYtVEIPhP8H4BmvJOFNWiwSFCO9BAIt1CFeL/otECBiLTRSJhfDr//8DyjPAiY306///q6uri/o70Q+DxAAAAIu19Ov//42FUPn//zv+cyEPtw+DxwKD+Qp1CWoNWmaJEIPAAmaJCIPAAo1N+DvBcttqAGoAaFUNAACNjfjr//9RjY1Q+f//K8HR+FCLwVBqAGjp/QAA6FPQ//+LdQiDxCCJhejr//+FwHRRM9uFwHQ1agCNjezr//8rw1FQjYX46///A8NQ/7Xw6////xV0YEEAhcB0JgOd7Ov//4uF6Ov//zvYcsuLxytFEIlGBDu99Ov//w+CRv///+sI/xU4YEEAiQaLTfyLxl9eM81b6DQw///Jw2oQaMjJQQDoNzn//4t1CIP+/nUY6BKI//+DIADoHYj//8cACQAAAOmzAAAAhfYPiJMAAAA7NQjxQQAPg4cAAACL3sH7BovGg+A/a8g4iU3giwSdCO9BAPZECCgBdGlW6G7W//9Zg8//iX3kg2X8AIsEnQjvQQCLTeD2RAgoAXUV6LmH///HAAkAAADom4f//4MgAOsU/3UQ/3UMVuhRAAAAg8QMi/iJfeTHRfz+////6AoAAACLx+spi3UIi33kVujC1v//WcPoX4f//4MgAOhqh///xwAJAAAA6KKG//+DyP+LTfBkiQ0AAAAAWV9eW8nDi/9Vi+yD7CiLTRCJTfxTVot1CFeLfQyJffSFyQ+EsQEAAIX/dSDoDof//4MgAOgZh///xwAWAAAA6FGG//+DyP/pjwEAAIvGi9bB+gaD4D9rwDiJVfCLFJUI70EAiUX4ilwCKYD7AnQFgPsBdQuLwffQqAF0sItF+PZEAiggdA9qAmoAagBW6AYjAACDxBBW6BL7//9ZhMB0OYTbdCL+y4D7AQ+H9AAAAP91/I1F2FdQ6In6//+DxAyL8OmcAAAA/3X8jUXYV1ZQ6MX2//+DxBDr5otF8IsMhQjvQQCLRfiAfAEoAH1GD77Dg+gAdC6D6AF0GYPoAQ+FoAAAAP91/I1F2FdWUOjo+///68H/dfyNRdhXVlDowfz//+ux/3X8jUXYV1ZQ6O36///roYtMARiNfdgzwKtqAKurjUXcUP91/P919FH/FXRgQQCFwHUJ/xU4YEEAiUXYjXXYjX3kpaWli0XohcB1ZYtF5IXAdCpqBV47xnUX6NCF///HAAkAAADosoX//4kw6bD+//9Q6IKF//9Z6aT+//+LffSLRfCLTfiLBIUI70EA9kQIKEB0BYA/GnQd6JGF///HABwAAADoc4X//4MgAOlw/v//K0Xs6wIzwF9eW8nDi/9Vi+yD7BD/dQyNTfDoq0///4tF9GgAgAAA/3UI/zDor2b//4PEDIB9/AB0CotN8IOhUAMAAP3Jw4v/VYvsi00IgDkAdQUzwEDrFoB5AQB1BWoCWOsLM8A4QQIPlcCDwANdwgQAi/9Vi+xR/3UUjUX8/3UQ/3UMUOgpMAAAi9CDxBCD+gR3GotN/IH5//8AAHYFuf3/AACLRQiFwHQDZokIi8LJw4v/VYvsUVGDfQgAU1ZXi30Miz8PhJwAAACLXRCLdQiF23RoV41N/+ho/////3UUUI1F+FdQ6McvAACL0IPEEIP6/3RchdJ0T4tN+IH5//8AAHYrg/sBdjOB6QAAAQBLi8GJTfjB6AqB4f8DAAANANgAAGaJBoPGAoHJANwAAGaJDgP6g8YCg+sBdZiLXQwrdQjR/ok761kz/zPAZokG6+uLRQyJOOgihP//xwAqAAAAg8j/6z0z2+sNhfZ0OoP+BHUBQwP+Q1eNTf/oxf7///91FFBXagDoJi8AAIvwg8QQg/7/ddTo4oP//8cAKgAAAIvGX15bycOLw+v3i/9Vi+yLVQiF0nUPM8mLRRCJCIlIBDPAQF3Di00Mhcl1BIgK6+j3wYD///91BIgK6+RTVvfBAPj//3UHM/azwEbrM/fBAAD//3UWgfkA2AAAcgiB+f/fAAB2Q2oCs+DrFPfBAADg/3U1gfn//xAAdy1qA7PwXleL/orBwekGJD8MgIgEF4PvAXXvi0UQCsuICjPJX4kIiUgEjUYB6wn/dRDoBQAAAFleW13Di/9Vi+yLRQiDIACDYAQA6BKD///HACoAAACDyP9dw4v/VYvsg30UAHULi0UIgDg1D53AXcPo4BoAAIXAdSuLVQiKAjw1fwt8TIN9EACNQgF1BbABXcNAigiA+TB0+ITJdfCKQv8kAV3DPQACAAB1EItFCIA4MHQdg30MLXQX69I9AAEAAHUOi0UIgDgwdAaDfQwtdL0ywF3Di/9Vi+xWV4t9CIX/dRboeoL/"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               