#!/bin/sh -e
# ESET PROTECT
# Copyright (c) 1992-2023 ESET, spol. s r.o. All Rights Reserved

cleanup_file="$(mktemp -q)"
finalize()
{
  set +e
  if test -f "$cleanup_file"
  then
    while read f
    do
      rm -f "$f"
    done < "$cleanup_file"
    rm -f "$cleanup_file"
  fi
}

trap 'finalize' HUP INT QUIT TERM EXIT

eraa_server_hostname="147.175.100.26"
eraa_server_port="2222"
eraa_server_company_name=""
eraa_peer_cert_b64="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"
eraa_peer_cert_pwd="Tk5FcmEyMDE1LkNvbnMy"
eraa_ca_cert_b64="MIIEuzCCAyOgAwIBAgIQc/AtfhXjdadL7Lczyt2N8DANBgkqhkiG9w0BAQUFADB2MScwJQYDVQQDEx5TZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDDAKBgNVBAsTA0ZFSTEQMA4GA1UEChMHRkVJIFNUVTELMAkGA1UEBxMCQkExETAPBgNVBAgTCFNsb3Zha2lhMQswCQYDVQQGEwJTSzAeFw0yNTA4MTkyMjAwMDBaFw0zNTA4MjAyMTU5NTlaMHYxJzAlBgNVBAMTHlNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEMMAoGA1UECxMDRkVJMRAwDgYDVQQKEwdGRUkgU1RVMQswCQYDVQQHEwJCQTERMA8GA1UECBMIU2xvdmFraWExCzAJBgNVBAYTAlNLMIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAxCSlJ5oNDJikQn4l7hXpv/XnCjLqlOpoMu4/7CUXAUmlBHrSAfbdBiDPlgz9DYhZ34IX0BkRw4r+rKEwi7lchmFZU9Fp8lrdsY1/wOBv5rH/gnhF4pYxMeDnJ20U9fhS64Lh1uxLcrK3nMcK/AvY71s6JG6mU8OD1dOgFpCd1ZNmd7XmOS3xZx/AoU7tioClVXEqGQLBMMaDVKc7rceIq8oqf8q1domRsPngl2DLeU3sF7Jv/NMfchD8/wKhvI0M8ki43KmK8KTLnyuO6DCBRtsUftpP97V0W3cqex8KMxv5733DN+O0StspVq1oTrs3s/zug4FcUUYUbD1z/UeUqAdSpI+nGh+Z7QTWqlQY9IbRHsr7qRJ2lNCJzXyodho6D9H5QZhQ/3kNfbIwfbbG8StJpPJPc+7bsq1YZY44m6RrSANSHxSJkwnP8jADroXy3hm4YeHteH2ym019FSuXftwRt00w9tsGquTYVvrdjjaoZgefvpBdIXE4f+LGTLqFAgMBAAGjRTBDMA4GA1UdDwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBRnXl5mFF91PjYndwVOxv8rVkTowjANBgkqhkiG9w0BAQUFAAOCAYEAO4BpNtnPa38d7pH40RQZ1unRk4wvn5jbjqciMfcQvUqORYQh6bn0Tfw10+BZ/GtMNIv1NQ9UpcEC5taPhHI4NuausO7NjRWtVkBfVxL5vIIylJldYq0ggTUZXFW2EQ37w/KwXh7btP+8hh5CpyxTVYkbf4bDV3NCyp1cX3krjScxycEVdZVC1yF7FF3PPegWnfKzpwqmySgJZkFe3Kgx73vp557JNXi+yWAKDWCTr3HCWCoSDV2Xof4lh6dGyv6P1D4didKPVHJzLmNnQ4xR0NoIYNO+kL6xnTq/BRzgAUVBx0wMUnS7YRLuPWhwFs8EBFgD/2qmTygHlLK1JBtaoXAoXgBj1t8InDhAxQfKr/f44pMxVlGs4yYPrr9HO4oJQmTpPWHu8eOCZ7P9pPGW84nMltTXXWdflYGPVnUgqSEAkj2kvtiMpZrWkvADFTR5LVclmTK2nIQuyi5eS7Flhse9xXSMsWclJRNxOsjjegiNsWXz0KGcyvHPy5RA/BOz"
eraa_product_uuid=""
eraa_initial_sg_token="MDAwMDAwMDAtMDAwMC0wMDAwLTcwMDEtMDAwMDAwMDAwMDAy4D2Q3BJ0RFOtFtygerC3Hlaw5bso4kjGhFCmUHoFM+Xsq0vcGbxic46tKkOKZ6vKHdjuDg=="
eraa_policy_data="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"

arch=$(uname -m)
eraa_installer_url="http://repository.eset.com/v1/com/eset/apps/business/era/agent/v11/11.2.3029.0/agent_linux_i386.sh"
eraa_installer_checksum="07dfa18ef1f1fa6fb4b92318bb3f9564b281bb9c9b3d999d647b89f0f14fbe02"

if $(echo "$arch" | grep -E "^(x86_64|amd64)$" 2>&1 > /dev/null)
then
    eraa_installer_url="http://repository.eset.com/v1/com/eset/apps/business/era/agent/v11/11.2.3029.0/agent_linux_x86_64.sh"
    eraa_installer_checksum="215c1422a8a48b654c15dad8d6a8d8dd983b428f0b5f29c31fdf8dfb353909f9"
fi

echo "ESET Management Agent live installer script. Copyright © 1992-2023 ESET, spol. s r.o. - All rights reserved."

if test ! -z $eraa_server_company_name
then
  echo " * CompanyName: $eraa_server_company_name"
fi
echo " * Hostname: $eraa_server_hostname"
echo " * Port: $eraa_server_port"
echo " * Installer: $eraa_installer_url"
echo

if test -z $eraa_installer_url
then
  echo "No installer available for '$arch' arhitecture."
  exit 1
fi

local_cert_path="$(mktemp -q -u)"
echo $eraa_peer_cert_b64 | base64 -d > "$local_cert_path" && echo "$local_cert_path" >> "$cleanup_file"

if test -n "$eraa_ca_cert_b64"
then
  local_ca_path="$(mktemp -q -u)"
  echo $eraa_ca_cert_b64 | base64 -d > "$local_ca_path" && echo "$local_ca_path" >> "$cleanup_file"
fi


eraa_http_proxy_value=""

local_installer="$(dirname $0)"/"$(basename $eraa_installer_url)"

if $(echo "$eraa_installer_checksum  $local_installer" | sha256sum -c 2> /dev/null > /dev/null)
then
    echo "Verified local installer was found: '$local_installer'"
else
    local_installer="$(mktemp -q -u)"

    echo "Downloading ESET Management Agent installer..."

    if test -n "$eraa_http_proxy_value"
    then
      export use_proxy=yes
      export http_proxy="$eraa_http_proxy_value"
      (wget --connect-timeout 300 --no-check-certificate -O "$local_installer" "$eraa_installer_url" || wget --connect-timeout 300 --no-proxy --no-check-certificate -O "$local_installer" "$eraa_installer_url" || curl --fail --connect-timeout 300 -k "$eraa_installer_url" > "$local_installer") && echo "$local_installer" >> "$cleanup_file"
    else
      (wget --connect-timeout 300 --no-check-certificate -O "$local_installer" "$eraa_installer_url" || curl --fail --connect-timeout 300 -k "$eraa_installer_url" > "$local_installer") && echo "$local_installer" >> "$cleanup_file"
    fi

    if test ! -s "$local_installer"
    then
       echo "Failed to download installer file"
       exit 2
    fi

    echo -n "Checking integrity of installer script " && echo "$eraa_installer_checksum  $local_installer" | sha256sum -c
fi

chmod +x "$local_installer"

command -v sudo > /dev/null && usesudo="sudo -E" || usesudo=""

export _ERAAGENT_PEER_CERT_PASSWORD="$eraa_peer_cert_pwd"

echo
echo Running installer script $local_installer
echo

$usesudo /bin/sh "$local_installer"\
   --skip-license \
   --hostname "$eraa_server_hostname"\
   --port "$eraa_server_port"\
   --cert-path "$local_cert_path"\
   --cert-password "env:_ERAAGENT_PEER_CERT_PASSWORD"\
   --cert-password-is-base64\
   --initial-static-group "$eraa_initial_sg_token"\
   \
   --disable-imp-program\
   $(test -n "$local_ca_path" && echo --cert-auth-path "$local_ca_path")\
   $(test -n "$eraa_product_uuid" && echo --product-guid "$eraa_product_uuid")\
   $(test -n "$eraa_policy_data" && echo --custom-policy "$eraa_policy_data")
